/*
*******************************************************************************
*
* File:         compact.h
* Description:  
* Author:       Christoph Schmidt
* Created:      22 Oct 1998, 08:29:35
* Modified:     Thu Nov  5 16:06:15 1998 (Henrik Liebau) Henrik_Liebau@HP.com
* Language:     Include File
* Package:      
* Status:       
*
* (C) Copyright 1998 by Hewlett-Packard GmbH, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __compact_H__
#define __compact_H__

#include <typedefs.h>
#include <compdefs.h> 

#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------
 * Compact PCI Functions
 * -----------------------------------------------------------------------
 */
  
CLI b_errtype EXPORT BestCPCIStatusSet(		/* @cpcisset */
  b_handletype     handle,
  b_cpcistatustype status,			/* @stat */
  b_int32 value					/* @val */
  );
  
CLI b_errtype EXPORT BestCPCIStatusGet(		/* @cpcisget */
  b_handletype   handle,
  b_cpcistatustype status, 			/* @stat */
  b_int32 *value				/* #RETURN "Value= %lx\\h\n" */
  );
  
CLI b_errtype EXPORT BestCPCIPinGet( 		/* @cpcipget */
  b_handletype		handle,
  b_cpcipintype		pin,              
  b_int32		*value			/* #RETURN "Value= %lu\n" */
  );
  
CLI b_errtype EXPORT BestCPCIPinSet( 		/* @cpcipset */
  b_handletype		handle,
  b_cpcipintype		pin,              
  b_int32		value			/* @val */
  );
  
#ifdef __cplusplus
}
#endif

#endif
